//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls  1.0
import wesual.data.Core 1.0
import wesual.Stage    1.0
import wesual.Ui        1.0
import wesual.Editor    1.0

import wesual.data.FoodService 1.0

UiGridButton {
    id : background

    property ListContainer container

    iconName     : "add"
    iconSize     : UiIcon.Icon_32x32
    anchors.fill : parent
    tooltip      : qsTrId("92d71d7c3982e3b9")
    onClicked    : flyout.show()

    ProductChooserPopup {
        id : flyout

        onProductsPicked : {
            Editor.context.beginRecordChanges();

            for (var i = 0; i < products.length; ++i) {
                var newItem = container.createItem();
                newItem.data.product = products[i];
            }

            Editor.context.endRecordChanges();
            flyout.hide();
        }
    }
}


